/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import util.ResourceManager;

public abstract class MissileEntity
extends Entity {
    protected CreatureEntity parent;
    protected GameState game;
    protected boolean removeWhenOutOfArea = true;
    protected double moveSpeed = 0.0;

    public MissileEntity(CreatureEntity parent, GameState game, String sprite, int x, int y) {
        super(sprite, x, y);
        this.parent = parent;
        this.game = game;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.removeWhenOutOfArea && (this.x < (double)(-this.sprite.getWidth()) || this.y < (double)(-this.sprite.getHeight()) || this.x > ResourceManager.get().getDimension().getWidth() || this.y > ResourceManager.get().getDimension().getHeight())) {
            this.game.removeEntity(this);
        }
    }
}

